
#ifndef _1_CRYS_SEP_ATP_AES_Acceptance_h_H
#define _1_CRYS_SEP_ATP_AES_Acceptance_h_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "CRYS.h"
#include "CRYS_SEP_ATP_Defines.h"

#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Sun Dec 12 12:56:19 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_SEP_ATP_AES_Acceptance.h#1:incl:1
   *  \author doronp
   *  \remarks Copyright (C) 2006 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/******** Defines **********/
/******** Enums ************/
/******** Typedefs  **********/
/******** Structs  **********/

/******** Public Variables ********/
/******** Public Functions ********/
/********************************************************************************
* Function Name:
*  SEPQA_AES_NotIntegrated
*
* Inputs:
* IVCounter_ptr - this parameter is the buffer of the IV or counters on mode CTR.
*                          In ECB mode this parameter has no use.
*                          In CBC and MAC modes this parameter should containe the IV values.
*                          in CTR mode this value shuld contain the init counter.
*
* Key_ptr - a pointer to the users key buffer.
* KeySize - The size of the KEY used on the AES : 128 , 196 or 256 bits as defined in the enum.
* EncryptDecryptFlag - This flag determains if the AES shall perform an Encrypt operation [0] or a
*                           Decrypt operation [1].
* OperationMode - The operation mode : ECB , CBC , MAC or CTR.
* is_secret_key - This paramrter defines do we use a secret key [1] or a key defined from the user [0].    
* DataIn_ptr - The pointer to the buffer of the input data to the AES. 
*                   The pointer's value does not need to be word-aligned.
* DataInSize - The size of the input data (must be not 0 and must be multiple of 16 bytes).
* ExpectedData_ptr - The pointer to the expected data of the AES operation. 
*                   The pointer's value does not need to be word-aligned.
* DataExpSize - The size of the expected data
* OutputLocation - indication if input buffer == output buffer or not.
* FailureFunctionNameOut_ptr - In case that function failures this parameter
*                                             returns the name of the function that failures
* FuncNameMaxSize - The allocated size of the FailureFunctionNameOut_ptr
*
* Outputs:
*  DxUint8_t - Function error return
*
* Description:
* This function is qa external application on the SEP, 
* that executes AES not integrated test
* Algorithm:     
* 1. Allocate memory buffers 
* 2. Calling the AES init function
* 3. Call the CRYS_AES_Block - This function is called N times 
*                              (N = number of blocks in data each block is 16byte) 
* 4. Calling the Free function
* 5. Compare the outputted result to the expected one  
* 6. Free allocated buffers
********************************************************************************/
CRYSError_t SEPQA_AES_NotIntegrated(CRYS_AES_IvCounter_t       IVCounter_ptr,       
									CRYS_AES_Key_t             Key_ptr,
									CRYS_AES_KeySize_t         KeySize,            
									CRYS_AES_EncryptMode_t     EncryptDecryptFlag, 
									CRYS_AES_OperationMode_t   OperationMode ,            
									DxUint8_t                  *DataIn_ptr,        
									DxUint32_t                 DataInSize,
									DxUint8_t                  *ExpectedData_ptr,        
									DxUint32_t                 DataExpSize,
									DxUint32_t				   OutputLocation,
									DxUint8_t                  *FailureFunctionNameOut_ptr);

/********************************************************************************
* Function Name:
*  SEPQA_AES_Integrated
*
* Inputs:
* IVCounter_ptr - this parameter is the buffer of the IV or counters on mode CTR.
*                          In ECB mode this parameter has no use.
*                          In CBC and MAC modes this parameter should containe the IV values.
*                          in CTR mode this value shuld contain the init counter.
*
* Key_ptr - a pointer to the users key buffer.
* KeySize - The size of the KEY used on the AES : 128 , 196 or 256 bits as defined in the enum.
* EncryptDecryptFlag - This flag determains if the AES shall perform an Encrypt operation [0] or a
*                           Decrypt operation [1].
* OperationMode - The operation mode : ECB , CBC , MAC or CTR.
* is_secret_key - This paramrter defines do we use a secret key [1] or a key defined from the user [0].    
* DataIn_ptr - The pointer to the buffer of the input data to the AES. 
*                   The pointer's value does not need to be word-aligned.
* DataInSize - The size of the input data (must be not 0 and must be multiple of 16 bytes).
* ExpectedData_ptr - The pointer to the expected data of the AES operation. 
*                   The pointer's value does not need to be word-aligned.
* DataExpSize - The size of the expected data
* OutputLocation - indication if input buffer == output buffer or not.
* FailureFunctionNameOut_ptr - In case that function failures this parameter
*                                             returns the name of the function that failures
* FuncNameMaxSize - The allocated size of the FailureFunctionNameOut_ptr
*
* Outputs:
*  DxUint8_t - Function error return
*
* Description:
* This function is qa external application on the SEP, 
* that executes AES integrated test
* Algorithm:     
* 1. Allocate memory buffers
* 2. Calling the AES integrated function
* 3. Compare the result to expected result
* 4. Free allocated buffers
********************************************************************************/
CRYSError_t SEPQA_AES_Integrated(
								 CRYS_AES_IvCounter_t       IVCounter_ptr,       
								 CRYS_AES_Key_t             Key_ptr,
								 CRYS_AES_KeySize_t         KeySize,            
								 CRYS_AES_EncryptMode_t     EncryptDecryptFlag, 
								 CRYS_AES_OperationMode_t   OperationMode ,            
								 DxUint8_t                  *DataIn_ptr,        
								 DxUint32_t                 DataInSize,
								 DxUint8_t                  *ExpectedDataOut_ptr,        
								 DxUint32_t                 DataExpSize,
								 int						OutputLocation,
								 DxUint8_t                  *FailureFunctionNameOut_ptr
								 );

/********************************************************************************
* Function Name:
*  SEPQA_AES_MAC_NON_Integrated
*
* Inputs:
* IVCounter_ptr - this parameter is the buffer of the IV or counters on mode CTR.
*                          In ECB mode this parameter has no use.
*                          In CBC and MAC modes this parameter should containe the IV values.
*                          in CTR mode this value shuld contain the init counter.
*
* Key_ptr - a pointer to the users key buffer.
* KeySize - The size of the KEY used on the AES : 128 , 196 or 256 bits as defined in the enum.
* EncryptDecryptFlag - This flag determains if the AES shall perform an Encrypt operation [0] or a
*                           Decrypt operation [1].
* OperationMode - The operation mode : ECB , CBC , MAC or CTR.
* is_secret_key - This paramrter defines do we use a secret key [1] or a key defined from the user [0].    
* DataIn_ptr - The pointer to the buffer of the input data to the AES. 
*                   The pointer's value does not need to be word-aligned.
* DataInSize - The size of the input data (must be not 0 and must be multiple of 16 bytes).
* ExpectedData_ptr - The pointer to the expected data of the AES operation. 
*                   The pointer's value does not need to be word-aligned.
* DataExpSize - The size of the expected data
* OutputLocation - indication if input buffer == output buffer or not.
* FailureFunctionNameOut_ptr - In case that function failures this parameter
*                                             returns the name of the function that failures
*
* Outputs:
*  DxUint8_t - Function error return
*
* Description:
* This function is qa external application on the SEP, 
* that executes AES not integrated test
* Algorithm:     
* 1. Allocate memory buffers 
* 2. Calling the AES init function
* 3. Call the CRYS_AES_Block - This function is called N times 
*                              (N = number of blocks in data each block is 16byte) 
* 4. Calling the Free function
* 5. Compare the outputted result to the expected one  
* 6. Free allocated buffers
********************************************************************************/

CRYSError_t SEPQA_AES_MAC_NON_Integrated(CRYS_AES_IvCounter_t       IVCounter_ptr,       
										 CRYS_AES_Key_t             Key_ptr,
										 CRYS_AES_KeySize_t         KeySize,            
										 CRYS_AES_EncryptMode_t     EncryptDecryptFlag, 
										 CRYS_AES_OperationMode_t   OperationMode ,             
										 DxUint8_t                  *DataIn_ptr,        
										 DxUint32_t                 DataInSize,
										 DxUint8_t*                 ExpectedDataOut_ptr,        
										 int					    OutputLocation,
										 char                      *FailureFunctionNameOut_ptr);



/********************************************************************************
* Function Name:
*  SEPQA_AES_XCBC_CMACNonIntegrated
*
* Inputs:
*
* Key_ptr - a pointer to the users key buffer.
* KeySize - The size of the KEY used on the AES : 128 , 196 or 256 bits as defined in the enum.
* EncryptDecryptFlag - This flag determains if the AES shall perform an Encrypt operation [0] or a
*                           Decrypt operation [1].
* OperationMode - The operation mode : ECB , CBC , MAC or CTR.
* is_secret_key - This paramrter defines do we use a secret key [1] or a key defined from the user [0].    
* DataIn_ptr - The pointer to the buffer of the input data to the AES. 
*                   The pointer's value does not need to be word-aligned.
* DataInSize - The size of the input data (must be not 0 and must be multiple of 16 bytes).
* ExpectedData_ptr - The pointer to the expected data of the AES operation. 
*                   The pointer's value does not need to be word-aligned.
* DataExpSize - The size of the expected data
* OutputLocation - indication if input buffer == output buffer or not.
* FailureFunctionNameOut_ptr - In case that function failures this parameter
*                                             returns the name of the function that failures
*
* Outputs:
*  DxUint8_t - Function error return
*
* Description:
* This function is qa external application on the SEP 
* This function Encrypts and Decrypts known vectors using AES new modes
* XCBC and CMAC
* AES modes                   - MAC   
* Vector sizes used (in bytes) - 16/32/512/1536                     
* Key Size used (in bits)     - 128/ 192 CMAC only / 256 CMAC only                              
* This also outputs the results to an output buffer or the same input buffer
* Algorithm:     
* 1. Allocate memory buffers 
* 2. Call the CRYS_AES_Init_XCBCandCMAC function to start the HASH process
* 3. Call the CRYS_AES_Block - This function is called N times 
*                              (N = number of blocks in data each block is 16byte) 
* 4. Call the CRYS_AES_XCBCandCMAC_Finish to end the encryption/decryption process 
* 5. Compare the outputted result to the expected one                                                   
*
******************************************************************************/

CRYSError_t SEPQA_AES_XCBC_CMACNonIntegrated(CRYS_AES_Key_t            Key_ptr,
											CRYS_AES_KeySize_t         KeySize,  
											CRYS_AES_OperationMode_t   OperationMode,
											DxUint8_t                  *DataIn_ptr,        
											DxUint32_t                 DataInSize,
											DxUint8_t                 *ExpectedDataOut_ptr,        
											int						   OutputLocation,
											char                      *FailureFunctionNameOut_ptr);


/*****************************************************************************
* Function Name:                                                           
*  SEPQA_AES_XCBC_CMACIntegrated      
*  
* Inputs:
* Key_ptr - a pointer to the users key buffer.
* KeySize - The size of the KEY used on the AES : 128 , 196 or 256 bits as defined in the enum.
* EncryptDecryptFlag - This flag determains if the AES shall perform an Encrypt operation [0] or a
*                           Decrypt operation [1].
* OperationMode - The operation mode : ECB , CBC , MAC or CTR.
* is_secret_key - This paramrter defines do we use a secret key [1] or a key defined from the user [0].    
* DataIn_ptr - The pointer to the buffer of the input data to the AES. 
*                   The pointer's value does not need to be word-aligned.
* DataInSize - The size of the input data (must be not 0 and must be multiple of 16 bytes).
* ExpectedData_ptr - The pointer to the expected data of the AES operation. 
*                   The pointer's value does not need to be word-aligned.
* DataExpSize - The size of the expected data
* OutputLocation - indication if input buffer == output buffer or not.
* FailureFunctionNameOut_ptr - In case that function failures this parameter
*                                             returns the name of the function that failures
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function Is a Acceptance test for AES non integrated API's                         
*  This function Encrypts and Decrypts known vectors using AES new modes
*  XCBC and CMAC
*  AES modes                   - XCBX/CMAC   
*  Vector sizes used (in bytes) - 1536                     
*  Key Size used (in bits)     -  256 CMAC only/Secret key 
*  
*  This also outputs the results to an output buffer or the same input buffer
* Algorithm:       
* 1. Call the CRYS_AES_XCBCandCMAC or CRYS_AES_XCBCandCMAC_SecretKey function to start the HASH process
* 2. Compare the outputted result to the expected one                                                   
*
******************************************************************************/

CRYSError_t SEPQA_AES_XCBC_CMACIntegrated(CRYS_AES_Key_t             Key_ptr,
										  CRYS_AES_KeySize_t         KeySize,            
										  CRYS_AES_OperationMode_t   OperationMode ,            
										  DxUint8_t                  *DataIn_ptr,        
										  DxUint32_t                 DataInSize,
										  DxUint8_t*                 ExpectedDataOut_ptr,        
										  int						  OutputLocation,
										  char						*FailureFunctionNameOut_ptr );



/*****************************************************************************
* Function Name:                                                           
*  SEPQA_AES_MAC_Integrated      
*  
*  Inputs:
* Key_ptr - a pointer to the users key buffer.
* KeySize - The size of the KEY used on the AES : 128 , 196 or 256 bits as defined in the enum.
* EncryptDecryptFlag - This flag determains if the AES shall perform an Encrypt operation [0] or a
*                           Decrypt operation [1].
* OperationMode - The operation mode : ECB , CBC , MAC or CTR.
* is_secret_key - This paramrter defines do we use a secret key [1] or a key defined from the user [0].    
* DataIn_ptr - The pointer to the buffer of the input data to the AES. 
*                   The pointer's value does not need to be word-aligned.
* DataInSize - The size of the input data (must be not 0 and must be multiple of 16 bytes).
* ExpectedData_ptr - The pointer to the expected data of the AES operation. 
*                   The pointer's value does not need to be word-aligned.
* DataExpSize - The size of the expected data
* OutputLocation - indication if input buffer == output buffer or not.
* FailureFunctionNameOut_ptr - In case that function failures this parameter
*                                             returns the name of the function that failures
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function Is a Acceptance test for AES non integrated API's                         
*  This function Encrypts and Decrypts known vectors using AES
*  AES modes                   - MAC/XCBC/CMAC   
*  Vector sizes used (in bytes) - 1536                           
*  Key Size used (in bits)     -  256(MAC only)
*  This also outputs the results to an output buffer or the same input buffer
* Algorithm:       
* 1. Call the CRYS_AES_Init function to start the encryption/decryption process
* 2. Compare the outputted result to the expected one                                                   
*
******************************************************************************/
CRYSError_t SEPQA_AES_MAC_Integrated(CRYS_AES_IvCounter_t       IVCounter_ptr,       
									 CRYS_AES_Key_t             Key_ptr,
									 CRYS_AES_KeySize_t         KeySize,            
									 CRYS_AES_EncryptMode_t     EncryptDecryptFlag, 
									 CRYS_AES_OperationMode_t   OperationMode ,           
									 DxUint8_t                  *DataIn_ptr,        
									 DxUint32_t                 DataInSize,
									 DxUint8_t*                 ExpectedDataOut_ptr,        
									 int						OutputLocation,
									 char						*FailureFunctionNameOut_ptr );

/*****************************************************************************
* Function Name:                                                           
*  DX_SEP_PARSER_AES_KeyWrapUnwarp      
*  
*  Inputs:
* Key_ptr - a pointer to the users key buffer.
* KeySize - The size of the KEY used on the AES : 128 , 196 or 256 bits as defined in the enum.
* EncryptDecryptFlag - This flag determains if the AES shall perform an Encrypt operation [0] or a
*                           Decrypt operation [1].
*
* is_secret_key - This paramrter defines do we use a secret key [1] or a key defined from the user [0].    
* DataIn_ptr - The pointer to the buffer of the input data to the AES. 
*                   The pointer's value does not need to be word-aligned.
* DataInSize - The size of the input data (must be not 0 and must be multiple of 16 bytes).
* ExpectedData_ptr - The pointer to the expected data of the AES operation. 
*                   The pointer's value does not need to be word-aligned.
* DataWrapSize - The size of buffer after Wrap operation
* OutputLocation - indication if input buffer == output buffer or not.
* FailureFunctionNameOut_ptr - In case that function failures this parameter
*                                             returns the name of the function that failures
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* DDescription:                                                                 
*  This function Is a Acceptance test for AES wrap unwrap  API's
*  This function wraps and unwraps known vectors using AES
*  Vector sizes used (in bytes) - 512                                 
*  Key Size used (in bits)     -  256                               
* Algorithm:       
* 1. Call the CRYS_Wrap and Unwrap function to use the AES wrap/unwrap process
* 2. Compare the outputted result to the expected one                                                     
*
******************************************************************************/
CRYSError_t SEPQA_AES_KeyWrapUnwarp(CRYS_AES_Key_t             Key_ptr,
											CRYS_AES_KeySize_t         KeySize,                          
											DxUint8_t                  *DataIn_ptr,        
											DxUint32_t                 DataInSize,
											DxUint8_t                  *ExpectedDataOut_ptr,        
											DxUint32_t                 WrapdDataSize,
											char					   *FailureFunctionNameOut_ptr );

#ifdef __cplusplus
}
#endif

#endif


